/* Script for -n: mix text and data on same page */
/* Linker script for Cortus APS executable. */

ENTRY(APP3PARTY_SEPMainParser)


MEMORY
{
  /* 0x90 bytes at start of data memory is reserved for 
     use by debugger. When debugging via jtag this can be
     reduced to 0x48 bytes. */
  D_CACHE :  org = 0x2000FC00, len = 1K
  INV_DATA :  org = 0x00000000, len = 0K
  CACHE :  org = 0x805CA80, len = 300K
};

SECTIONS
{

/****************************************
CACHE CODE AREA
****************************************/
  .cache 0x805CA80:
  {
    *(.init);
    *(.text);
    *(.text.*);
    *(.libgcc);
    *(.rodata);
    *(.rodata.*);
	. = ALIGN(0x40);
  } > CACHE

/****************************************
GLOBAL VARIABLES SECTION
****************************************/
  .ram_permanet_vars :
  {
     *(.gnu.linkonce.b*);
     *(COMMON);
    *(.bss);
    *(.bss.*);
  } > D_CACHE




/****************************************
GENERAL NON PERMANENT VARIABLES SECTION
****************************************/

  .sdata :
  {
    *(.sdata);
  } > INV_DATA 

  .data :
  {
     _data = .;
    *(.data);
    *(.data.*);
    *(.gnu.linkonce.d*);
     _edata = .;
  } > INV_DATA 

  .sbss :
  {
     _sbss_c = .;
    *(.sbss);
    *(.sbss.*);
    *(.scommon);
    *(.gnu.linkonce.s*);
     _esbss_c = .;
  } > INV_DATA



/* Stabs debugging sections.  */
  .stab 0 : { *(.stab) }
  .stabstr 0 : { *(.stabstr) }
  .stab.excl 0 : { *(.stab.excl) }
  .stab.exclstr 0 : { *(.stab.exclstr) }
  .stab.index 0 : { *(.stab.index) }
  .stab.indexstr 0 : { *(.stab.indexstr) }
  .comment 0 : { *(.comment) }
  /* DWARF debug sections.
     Symbols in the DWARF debugging sections are relative to the beginning
     of the section so we begin them at 0.  */
  /* DWARF 1 */
  .debug          0 : { *(.debug) }
  .line           0 : { *(.line) }
  /* GNU DWARF 1 extensions */
  .debug_srcinfo  0 : { *(.debug_srcinfo) }
  .debug_sfnames  0 : { *(.debug_sfnames) }
  /* DWARF 1.1 and DWARF 2 */
  .debug_aranges  0 : { *(.debug_aranges) }
  .debug_pubnames 0 : { *(.debug_pubnames) }
  /* DWARF 2 */
  .debug_info     0 : { *(.debug_info) *(.gnu.linkonce.wi.*) }
  .debug_abbrev   0 : { *(.debug_abbrev) }
  .debug_line     0 : { *(.debug_line) }
  .debug_frame    0 : { *(.debug_frame) }
  .debug_str      0 : { *(.debug_str) }
  .debug_loc      0 : { *(.debug_loc) }
  .debug_macinfo  0 : { *(.debug_macinfo) }
  /* SGI/MIPS DWARF 2 extensions */
  .debug_weaknames 0 : { *(.debug_weaknames) }
  .debug_funcnames 0 : { *(.debug_funcnames) }
  .debug_typenames 0 : { *(.debug_typenames) }
  .debug_varnames  0 : { *(.debug_varnames) }

}
